@extends('layouts.admin')

@section('title', 'Edit Server')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>Edit Server: {{ $server->name }}</h1>
            <div>
                <a href="{{ route('admin.servers.show', $server->id) }}" class="btn btn-secondary mr-sm">
                    <i class="fas fa-eye"></i> View Server
                </a>
                <a href="{{ route('admin.servers.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Servers
                </a>
            </div>
        </div>
        <p>Update server details</p>
    </div>

    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>Server Details</h3>
        </div>
        <div class="dashboard-card-body">
            <form action="{{ route('admin.servers.update', $server->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="form-group">
                    <label for="name">Server Name</label>
                    <input type="text" name="name" id="name" class="form-control @error('name') has-error @enderror" value="{{ old('name', $server->name) }}" required>
                    @error('name')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="ip">IP Address</label>
                            <input type="text" name="ip" id="ip" class="form-control @error('ip') has-error @enderror" value="{{ old('ip', $server->ip) }}" required>
                            @error('ip')
                                <div class="error-message">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="port">Port</label>
                            <input type="number" name="port" id="port" class="form-control @error('port') has-error @enderror" value="{{ old('port', $server->port) }}" min="1" max="65535" required>
                            @error('port')
                                <div class="error-message">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="app_id">Steam App ID</label>
                    <input type="text" name="app_id" id="app_id" class="form-control @error('app_id') has-error @enderror" value="{{ old('app_id', $server->app_id) }}" placeholder="4000 for Garry's Mod">
                    <div class="form-text">Default: 4000 (Garry's Mod)</div>
                    @error('app_id')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="form-check mb-4">
                    <input type="checkbox" name="is_active" id="is_active" class="form-check-input" {{ old('is_active', $server->is_active) ? 'checked' : '' }}>
                    <label for="is_active">Active</label>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Update Server
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection